import "core-js/stable/array/at.js";
import "core-js/stable/array/flat-map.js";
import "core-js/stable/array/flat.js";
import "core-js/stable/string/at.js";
import "core-js/stable/string/replace-all.js";
import { featureFlags } from "./lib/utils/debug-flags.mjs";
export * from "@tldraw/store";
export * from "@tldraw/tlschema";
export * from "@tldraw/utils";
export * from "@tldraw/validate";
import {
  EMPTY_ARRAY,
  EffectScheduler,
  atom,
  computed,
  react,
  transact,
  transaction,
  whyAmIRunning
} from "@tldraw/state";
import {
  track,
  useComputed,
  useQuickReactor,
  useReactor,
  useStateTracking,
  useValue
} from "@tldraw/state-react";
import {
  ErrorScreen,
  LoadingScreen,
  TldrawEditor,
  useOnMount
} from "./lib/TldrawEditor.mjs";
import {
  ErrorBoundary,
  OptionalErrorBoundary
} from "./lib/components/ErrorBoundary.mjs";
import { HTMLContainer } from "./lib/components/HTMLContainer.mjs";
import { SVGContainer } from "./lib/components/SVGContainer.mjs";
import { DefaultBackground } from "./lib/components/default-components/DefaultBackground.mjs";
import { DefaultBrush } from "./lib/components/default-components/DefaultBrush.mjs";
import {
  DefaultCanvas
} from "./lib/components/default-components/DefaultCanvas.mjs";
import {
  DefaultCollaboratorHint
} from "./lib/components/default-components/DefaultCollaboratorHint.mjs";
import {
  DefaultCursor
} from "./lib/components/default-components/DefaultCursor.mjs";
import {
  DefaultErrorFallback
} from "./lib/components/default-components/DefaultErrorFallback.mjs";
import { DefaultGrid } from "./lib/components/default-components/DefaultGrid.mjs";
import {
  DefaultHandle
} from "./lib/components/default-components/DefaultHandle.mjs";
import {
  DefaultHandles
} from "./lib/components/default-components/DefaultHandles.mjs";
import {
  DefaultScribble
} from "./lib/components/default-components/DefaultScribble.mjs";
import {
  DefaultSelectionBackground
} from "./lib/components/default-components/DefaultSelectionBackground.mjs";
import {
  DefaultSelectionForeground
} from "./lib/components/default-components/DefaultSelectionForeground.mjs";
import {
  DefaultShapeIndicator
} from "./lib/components/default-components/DefaultShapeIndicator.mjs";
import { DefaultShapeIndicators } from "./lib/components/default-components/DefaultShapeIndicators.mjs";
import {
  DefaultSnapIndicator
} from "./lib/components/default-components/DefaultSnapIndictor.mjs";
import { DefaultSpinner } from "./lib/components/default-components/DefaultSpinner.mjs";
import { DefaultSvgDefs } from "./lib/components/default-components/DefaultSvgDefs.mjs";
import { getSnapshot, loadSnapshot } from "./lib/config/TLEditorSnapshot.mjs";
import {
  TAB_ID,
  createSessionStateSnapshotSignal,
  extractSessionStateFromLegacySnapshot,
  loadSessionStateSnapshotIntoStore
} from "./lib/config/TLSessionStateSnapshot.mjs";
import {
  USER_COLORS,
  defaultUserPreferences,
  getFreshUserPreferences,
  getUserPreferences,
  setUserPreferences
} from "./lib/config/TLUserPreferences.mjs";
import {
  createTLSchemaFromUtils,
  createTLStore,
  inlineBase64AssetStore
} from "./lib/config/createTLStore.mjs";
import { createTLUser, useTldrawUser } from "./lib/config/createTLUser.mjs";
import { coreShapes } from "./lib/config/defaultShapes.mjs";
import { DEFAULT_ANIMATION_OPTIONS, DEFAULT_CAMERA_OPTIONS, SIDES } from "./lib/constants.mjs";
import {
  Editor
} from "./lib/editor/Editor.mjs";
import {
  BindingUtil
} from "./lib/editor/bindings/BindingUtil.mjs";
import { ClickManager } from "./lib/editor/managers/ClickManager.mjs";
import { EdgeScrollManager } from "./lib/editor/managers/EdgeScrollManager.mjs";
import { EnvironmentManager } from "./lib/editor/managers/EnvironmentManager.mjs";
import { HistoryManager } from "./lib/editor/managers/HistoryManager.mjs";
import { ScribbleManager } from "./lib/editor/managers/ScribbleManager.mjs";
import {
  BoundsSnaps
} from "./lib/editor/managers/SnapManager/BoundsSnaps.mjs";
import { HandleSnaps } from "./lib/editor/managers/SnapManager/HandleSnaps.mjs";
import {
  SnapManager
} from "./lib/editor/managers/SnapManager/SnapManager.mjs";
import { TextManager } from "./lib/editor/managers/TextManager.mjs";
import { UserPreferencesManager } from "./lib/editor/managers/UserPreferencesManager.mjs";
import { BaseBoxShapeUtil } from "./lib/editor/shapes/BaseBoxShapeUtil.mjs";
import {
  ShapeUtil
} from "./lib/editor/shapes/ShapeUtil.mjs";
import { GroupShapeUtil } from "./lib/editor/shapes/group/GroupShapeUtil.mjs";
import { resizeBox } from "./lib/editor/shapes/shared/resizeBox.mjs";
import { BaseBoxShapeTool } from "./lib/editor/tools/BaseBoxShapeTool/BaseBoxShapeTool.mjs";
import { StateNode } from "./lib/editor/tools/StateNode.mjs";
import {
  useSvgExportContext
} from "./lib/editor/types/SvgExportContext.mjs";
import {
  EVENT_NAME_MAP
} from "./lib/editor/types/event-types.mjs";
import { ContainerProvider, useContainer } from "./lib/hooks/useContainer.mjs";
import { getCursor } from "./lib/hooks/useCursor.mjs";
import { useEditor } from "./lib/hooks/useEditor.mjs";
import { useEditorComponents } from "./lib/hooks/useEditorComponents.mjs";
import { useEvent } from "./lib/hooks/useEvent.mjs";
import { useShallowArrayIdentity, useShallowObjectIdentity } from "./lib/hooks/useIdentity.mjs";
import { useIsCropping } from "./lib/hooks/useIsCropping.mjs";
import { useIsDarkMode } from "./lib/hooks/useIsDarkMode.mjs";
import { useIsEditing } from "./lib/hooks/useIsEditing.mjs";
import { useLocalStore } from "./lib/hooks/useLocalStore.mjs";
import { usePeerIds } from "./lib/hooks/usePeerIds.mjs";
import { usePresence } from "./lib/hooks/usePresence.mjs";
import { useRefState } from "./lib/hooks/useRefState.mjs";
import { useSafeId } from "./lib/hooks/useSafeId.mjs";
import { useSelectionEvents } from "./lib/hooks/useSelectionEvents.mjs";
import { useTLSchemaFromUtils, useTLStore } from "./lib/hooks/useTLStore.mjs";
import { useTransform } from "./lib/hooks/useTransform.mjs";
import { defaultTldrawOptions } from "./lib/options.mjs";
import {
  Box,
  ROTATE_CORNER_TO_SELECTION_CORNER,
  rotateSelectionHandle
} from "./lib/primitives/Box.mjs";
import { Mat } from "./lib/primitives/Mat.mjs";
import { Vec } from "./lib/primitives/Vec.mjs";
import { EASINGS } from "./lib/primitives/easings.mjs";
import { Arc2d } from "./lib/primitives/geometry/Arc2d.mjs";
import { Circle2d } from "./lib/primitives/geometry/Circle2d.mjs";
import { CubicBezier2d } from "./lib/primitives/geometry/CubicBezier2d.mjs";
import { CubicSpline2d } from "./lib/primitives/geometry/CubicSpline2d.mjs";
import { Edge2d } from "./lib/primitives/geometry/Edge2d.mjs";
import { Ellipse2d } from "./lib/primitives/geometry/Ellipse2d.mjs";
import { Geometry2d } from "./lib/primitives/geometry/Geometry2d.mjs";
import { Group2d } from "./lib/primitives/geometry/Group2d.mjs";
import { Point2d } from "./lib/primitives/geometry/Point2d.mjs";
import { Polygon2d } from "./lib/primitives/geometry/Polygon2d.mjs";
import { Polyline2d } from "./lib/primitives/geometry/Polyline2d.mjs";
import { Rectangle2d } from "./lib/primitives/geometry/Rectangle2d.mjs";
import { Stadium2d } from "./lib/primitives/geometry/Stadium2d.mjs";
import {
  intersectCircleCircle,
  intersectCirclePolygon,
  intersectCirclePolyline,
  intersectLineSegmentCircle,
  intersectLineSegmentLineSegment,
  intersectLineSegmentPolygon,
  intersectLineSegmentPolyline,
  intersectPolygonBounds,
  intersectPolygonPolygon,
  linesIntersect,
  polygonIntersectsPolyline,
  polygonsIntersect
} from "./lib/primitives/intersect.mjs";
import {
  HALF_PI,
  PI,
  PI2,
  SIN,
  angleDistance,
  approximately,
  areAnglesCompatible,
  average,
  canonicalizeRotation,
  centerOfCircleFromThreePoints,
  clamp,
  clampRadians,
  clockwiseAngleDist,
  counterClockwiseAngleDist,
  degreesToRadians,
  getArcMeasure,
  getPointInArcT,
  getPointOnCircle,
  getPointsOnArc,
  getPolygonVertices,
  isSafeFloat,
  perimeterOfEllipse,
  pointInPolygon,
  precise,
  radiansToDegrees,
  rangeIntersection,
  shortAngleDist,
  snapAngle,
  toDomPrecision,
  toFixed,
  toPrecision
} from "./lib/primitives/utils.mjs";
import {
  ReadonlySharedStyleMap,
  SharedStyleMap
} from "./lib/utils/SharedStylesMap.mjs";
import { dataUrlToFile, getDefaultCdnBaseUrl } from "./lib/utils/assets.mjs";
import {
  debugFlags,
  featureFlags as featureFlags2
} from "./lib/utils/debug-flags.mjs";
import {
  loopToHtmlElement,
  preventDefault,
  releasePointerCapture,
  setPointerCapture,
  stopEventPropagation
} from "./lib/utils/dom.mjs";
import { getIncrementedName } from "./lib/utils/getIncrementedName.mjs";
import { getPointerInfo } from "./lib/utils/getPointerInfo.mjs";
import { getSvgPathFromPoints } from "./lib/utils/getSvgPathFromPoints.mjs";
import { hardResetEditor } from "./lib/utils/hardResetEditor.mjs";
import { normalizeWheel } from "./lib/utils/normalizeWheel.mjs";
import { refreshPage } from "./lib/utils/refreshPage.mjs";
import {
  applyRotationToSnapshotShapes,
  getRotationSnapshot
} from "./lib/utils/rotation.mjs";
import { runtime, setRuntimeOverrides } from "./lib/utils/runtime.mjs";
import { hardReset } from "./lib/utils/sync/hardReset.mjs";
import { uniq } from "./lib/utils/uniq.mjs";
import { uniqueId } from "./lib/utils/uniqueId.mjs";
import { openWindow } from "./lib/utils/window-open.mjs";
function debugEnableLicensing() {
  featureFlags.enableLicensing.set(true);
}
export {
  Arc2d,
  BaseBoxShapeTool,
  BaseBoxShapeUtil,
  BindingUtil,
  BoundsSnaps,
  Box,
  Circle2d,
  ClickManager,
  ContainerProvider,
  CubicBezier2d,
  CubicSpline2d,
  DEFAULT_ANIMATION_OPTIONS,
  DEFAULT_CAMERA_OPTIONS,
  DefaultBackground,
  DefaultBrush,
  DefaultCanvas,
  DefaultCollaboratorHint,
  DefaultCursor,
  DefaultErrorFallback,
  DefaultGrid,
  DefaultHandle,
  DefaultHandles,
  DefaultScribble,
  DefaultSelectionBackground,
  DefaultSelectionForeground,
  DefaultShapeIndicator,
  DefaultShapeIndicators,
  DefaultSnapIndicator,
  DefaultSpinner,
  DefaultSvgDefs,
  EASINGS,
  EMPTY_ARRAY,
  EVENT_NAME_MAP,
  Edge2d,
  EdgeScrollManager,
  Editor,
  EffectScheduler,
  Ellipse2d,
  EnvironmentManager,
  ErrorBoundary,
  ErrorScreen,
  Geometry2d,
  Group2d,
  GroupShapeUtil,
  HALF_PI,
  HTMLContainer,
  HandleSnaps,
  HistoryManager,
  LoadingScreen,
  Mat,
  OptionalErrorBoundary,
  PI,
  PI2,
  Point2d,
  Polygon2d,
  Polyline2d,
  ROTATE_CORNER_TO_SELECTION_CORNER,
  ReadonlySharedStyleMap,
  Rectangle2d,
  SIDES,
  SIN,
  SVGContainer,
  ScribbleManager,
  ShapeUtil,
  SharedStyleMap,
  SnapManager,
  Stadium2d,
  StateNode,
  TAB_ID,
  TextManager,
  TldrawEditor,
  USER_COLORS,
  UserPreferencesManager,
  Vec,
  angleDistance,
  applyRotationToSnapshotShapes,
  approximately,
  areAnglesCompatible,
  atom,
  average,
  canonicalizeRotation,
  centerOfCircleFromThreePoints,
  clamp,
  clampRadians,
  clockwiseAngleDist,
  computed,
  coreShapes,
  counterClockwiseAngleDist,
  createSessionStateSnapshotSignal,
  createTLSchemaFromUtils,
  createTLStore,
  createTLUser,
  dataUrlToFile,
  debugEnableLicensing,
  debugFlags,
  defaultTldrawOptions,
  defaultUserPreferences,
  degreesToRadians,
  extractSessionStateFromLegacySnapshot,
  featureFlags2 as featureFlags,
  getArcMeasure,
  getCursor,
  getDefaultCdnBaseUrl,
  getFreshUserPreferences,
  getIncrementedName,
  getPointInArcT,
  getPointOnCircle,
  getPointerInfo,
  getPointsOnArc,
  getPolygonVertices,
  getRotationSnapshot,
  getSnapshot,
  getSvgPathFromPoints,
  getUserPreferences,
  hardReset,
  hardResetEditor,
  inlineBase64AssetStore,
  intersectCircleCircle,
  intersectCirclePolygon,
  intersectCirclePolyline,
  intersectLineSegmentCircle,
  intersectLineSegmentLineSegment,
  intersectLineSegmentPolygon,
  intersectLineSegmentPolyline,
  intersectPolygonBounds,
  intersectPolygonPolygon,
  isSafeFloat,
  linesIntersect,
  loadSessionStateSnapshotIntoStore,
  loadSnapshot,
  loopToHtmlElement,
  normalizeWheel,
  openWindow,
  perimeterOfEllipse,
  pointInPolygon,
  polygonIntersectsPolyline,
  polygonsIntersect,
  precise,
  preventDefault,
  radiansToDegrees,
  rangeIntersection,
  react,
  refreshPage,
  releasePointerCapture,
  resizeBox,
  rotateSelectionHandle,
  runtime,
  setPointerCapture,
  setRuntimeOverrides,
  setUserPreferences,
  shortAngleDist,
  snapAngle,
  stopEventPropagation,
  toDomPrecision,
  toFixed,
  toPrecision,
  track,
  transact,
  transaction,
  uniq,
  uniqueId,
  useComputed,
  useContainer,
  useEditor,
  useEditorComponents,
  useEvent,
  useIsCropping,
  useIsDarkMode,
  useIsEditing,
  useLocalStore,
  useOnMount,
  usePeerIds,
  usePresence,
  useQuickReactor,
  useReactor,
  useRefState,
  useSafeId,
  useSelectionEvents,
  useShallowArrayIdentity,
  useShallowObjectIdentity,
  useStateTracking,
  useSvgExportContext,
  useTLSchemaFromUtils,
  useTLStore,
  useTldrawUser,
  useTransform,
  useValue,
  whyAmIRunning
};
//# sourceMappingURL=index.mjs.map
